<?php

namespace App\Http\Resources\User;

use App\Http\Resources\User\LinkResource;
use Illuminate\Http\Resources\Json\Resource;

class SponsorResource extends Resource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id'            => $this->id,
            'name'          => $this->name,
            'username'      => $this->username,
            'email'         => $this->email,
            'photo_url'     => $this->photo_url,
            'referral_link' => new LinkResource($this->whenLoaded('referralLink'))
        ];
    }
}
