<?php $__env->startSection('content'); ?>
    <div id="content-page" class="content-page">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-6 offset-3">
                    <div class="iq-card">
                        <div class="iq-card-header d-flex justify-content-between">
                            <div class="iq-header-title">
                                <h4 class="card-title"> <?php echo e($pageTitle ?? trans('messages.form')); ?> </h4>
                            </div>
                            <div class="iq-card-header-toolbar d-flex align-items-center">
                                <a href="<?php echo e(route('board.index')); ?>" class="float-right mr-1 btn btn-sm btn-primary"><i class="ri-arrow-drop-left-line"></i><?php echo e(trans('messages.back')); ?></a> 
                            </div>
                        </div>
                        <div class="iq-card-body">
                        <form method="POST" action="<?php echo e(route('board.reorder.save')); ?>">
                            <input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
                            <section class="">
                                <ul class="list-unstyled m-1" id="drag-list">
                                    <?php if( count($boarddata) > 0 ): ?>
                                        <?php $__currentLoopData = $boarddata; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li class="iq-card m-2 p-3 cursor-move">
                                                <input type="hidden" name="id[]" value="<?php echo e($data->id); ?>">
                                                <span class="title board_title">
                                                    <i class="fa fa-bars drag-area" aria-hidden="true"></i>
                                                    <?php echo e($data->title); ?>

                                                </span>
                                            </li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                </ul>
                            </section>
                            <div class="modal-footer">
                                <button class="btn btn-md btn-primary" ><?php echo e(trans('messages.save')); ?></button>
                            </div>
                        </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('body_bottom'); ?>
    <script type="text/javascript">
        (function($) {
        "use strict";
            $(document).ready(function(){
                var sequence = [];
                dragula([$("#drag-list").get(0)]).on("dragend", function(el, target, src) {
                    console.log(el)
                    sequence = [];
                    $(".board_title").each(function(idx, elem) {
                        sequence.push($(elem).text());
                    });
                });
            })
    })(jQuery);
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/Dashboard/laravel-dashboard/resources/views/board/reorder.blade.php ENDPATH**/ ?>