<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class UserController extends CI_Controller
{
	public $ci;

	function __construct()
	{
		parent::__construct();
		$this->load->helper('url');
        $this->load->library('tank_auth');
        $this->load->library('session');
		$this->load->helper('form');
		$this->load->model("Users");
		$this->load->model('MessageModel');
		$this->ci =& get_instance();
	}

	function index()
	{
		if (!$this->tank_auth->is_logged_in()) {
			redirect('/auth/login/');
		} else {
            $data['users'] =$this->Users->all();
			$data['page_name']  = "users/user";
			$data['assets'] = 'datatable';
			$this->load->view('index', $data);
		}
	}
	function add_user(){
		$this->load->model('Role');
		$data['roles']=$this->Role->all();
		$data['page_name']  = "users/create";
		$this->load->view('index', $data);
    }
    
    function save_user(){
		$data = $this->input->post();
		$password =$this->input->post('password');

        $hasher = new PasswordHash(
            $this->ci->config->item('phpass_hash_strength', 'tank_auth'),
            $this->ci->config->item('phpass_hash_portable', 'tank_auth'));
        $data['password'] = $hasher->HashPassword($password);
        if(isset($data) && !empty($data)){
            $this->Users->create_user($data);
		}
		$this->MessageModel->set_messagge('Success','User added successfully','success');
		redirect(base_url('index.php/user-list'));
    }
	function delete($id){
        $item = $this->Users->delete_user($id);
        $this->MessageModel->set_messagge('Success','Deleted successfully','success');
        redirect(base_url('index.php/user-list'));
      }
    

	
   
}

/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */