<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateLinksTable extends Migration
{
    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('links');
    }

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('links', function (Blueprint $table) {
            $table->unsignedBigInteger('id')->unique();
            $table->string('link', 60)->unique();
            $table->unsignedBigInteger('user_id')->nullable();
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
            $table->unsignedBigInteger('sp_user_id')->nullable();
            $table->unsignedBigInteger('sp_link_id')->nullable();
            $table->boolean('active')->default(0);
            $table->timestamp('date_activated')->nullable();
            $table->timestamps();
        });
    }
}
