<?php $__env->startSection('content'); ?>

<div id="content-page" class="content-page">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="row">
                    <div class="col-12">
                        <div class="iq-card">
                            <div class="iq-card-header d-flex justify-content-between">
                                <div class="iq-header-title">
                                    <h4 class="card-title"><?php echo e($pageTitle ?? trans('messages.list')); ?></h4>
                                </div>
                                <div class="iq-card-header-toolbar d-flex align-items-center">
                                    <?php if($auth_user->can('board add')): ?>
                                    <?php endif; ?>
                                    <?php if(isset($boarddata) && count($boarddata) > 0 ): ?>
                                        <a href="<?php echo e(route('board.reorder.get')); ?>" class="float-right mr-1 btn btn-sm btn-primary"><?php echo e(trans('messages.sequence_form_title',['form' => trans('messages.board')  ])); ?></a> 
                                    <?php endif; ?>
                                    <a href="<?php echo e(route('board.create')); ?>" class="float-right mr-1 btn btn-sm btn-primary loadRemoteModel"><i class="fa fa-plus-circle"></i> <?php echo e(trans('messages.add_form_title',['form' => trans('messages.board')  ])); ?></a> 
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12 track">
                        <?php if(isset($boarddata) && count($boarddata) > 0 ): ?>
                            <?php $__currentLoopData = $boarddata; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="bg-transparent shadow-none mr-3 w-25 iq-card">
                                    <div class="iq-card-header d-flex justify-content-between" style="background-color:<?php echo e($item->color); ?>" >
                                        <div class="iq-header-title">
                                            <h5 class="text-white"><?php echo e($item->title); ?></h5>
                                        </div>
                                        <div class="iq-card-header-toolbar d-flex align-items-center">
                                            <a href="<?php echo e(route('board.edit', [ 'id' => $item->id ])); ?>" class="text-white loadRemoteModel" ><i class="ri-ball-pen-line mr-0 font-size-18" role="button" tabindex="0"></i></a>
                                            <a href="<?php echo e(route('board.delete',['id' => $item->id])); ?>" title="<?php echo e(trans('messages.delete_form_title',['form'=>  trans('messages.board') ])); ?>"  onclick="return confirm('<?php echo e(trans('messages.delete_form_message',['form' => trans('messages.board')])); ?>')"><i class="ri-delete-bin-line font-size-18 ml-2 text-white"></i></a>
                                        </div>
                                    </div>
                                    <div class="card-body iq-card-body pro-bg-card">
                                        <div class="mt-n3" id="board<?php echo e($k++); ?>" data-board_id ="<?php echo e($item->id); ?>">
                                            &nbsp;
                                            <?php if(isset($item->boardTask) && count($item->boardTask) > 0): ?>
                                                <?php $__currentLoopData = $item->boardTask; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $task): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <div class="iq-card" data-boardtask_id ="<?php echo e($task->id); ?>">
                                                        <div class="iq-card-header d-flex justify-content-between pro-task-bg-card">
                                                            <div class="iq-header-title">
                                                                <h5 class="card-title text-muted"><?php echo e($task->name); ?></h5>
                                                                <h6 class="text-muted"><?php echo e($task->date); ?></h6>
                                                            </div>
                                                            <div class="iq-card-header-toolbar d-flex align-items-center">
                                                                <?php if(isset($task->priority)): ?>
                                                                    <?php $__currentLoopData = $taskpriority; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $priority): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                        <span class="badge <?php echo e($priority['color']); ?> mr-2 p-2 text-capitalize"><?php echo e(($task->priority == $priority['value']) ? $key : ''); ?></span>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                <?php endif; ?>
                                                            </div>
                                                        </div>
                                                        <div class="card-body iq-card-body pro-task-bg-card">
                                                            <p class="font-size-12"> <?php echo e($task->description); ?></p>
                                                            <div class="d-flex justify-content-between">
                                                                <div>
                                                                    <a href="<?php echo e(route('boardtask.edit' ,[ 'id' => $task->id ])); ?>" title="<?php echo e(trans('messages.update_form_title',['form' => trans('messages.boardtask') ])); ?>" class="loadRemoteModel" ><i class="ri-ball-pen-line font-size-18" role="button" tabindex="0"></i></a>
                                                                    <a href="<?php echo e(route('boardtask.delete',['id' => $task->id])); ?>" title="<?php echo e(trans('messages.delete_form_title',['form'=>  trans('messages.boardtask') ])); ?>"  onclick="return confirm('<?php echo e(trans('messages.delete_form_message',['form' => trans('messages.boardtask')])); ?>')"><i class="ri-delete-bin-line font-size-18 iq-bg-danger"></i></a>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php endif; ?>
                                        </div>
                                        <a href="<?php echo e(route('boardtask.create' ,[ 'board_id' => $item->id ])); ?>" class="btn iq-bg-primary btn-lg btn-block loadRemoteModel"><?php echo e(trans('messages.add_form_title' , [ 'form' => trans('messages.item') ])); ?></a>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('body_bottom'); ?>

<script type="text/javascript">
    (function($) {
        "use strict";
        $(document).ready(function(){
            var board =  <?php echo json_encode($boarddata); ?>;

            var selector = [];
            if(board.length > 0 )
            {
                for(var i = 0 ; i < board.length ; i++) {
                    selector.push(document.querySelector('#board'+i));
                }
            }
            dragula( selector ).on('drop', function(el) {
                
                var board_id = $(el).parent().attr('data-board_id')
                var boardtask_id = el.dataset.boardtask_id
               
                $.ajax({
                    url: "<?php echo e(route('boardtask.update')); ?>",
                    type: 'post',
                    data: { 'board_id' : board_id , 'boardtask_id' : boardtask_id , '_token': $('input[name=_token]').val() }
                })
            });
        })
        })(jQuery);
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/Dashboard/laravel-dashboard/resources/views/board/index.blade.php ENDPATH**/ ?>