/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter.javahl;

import java.util.logging.Logger;
import org.tigris.subversion.javahl.ChangePath;
import org.tigris.subversion.javahl.DirEntry;
import org.tigris.subversion.javahl.Lock;
import org.tigris.subversion.javahl.LogMessage;
import org.tigris.subversion.javahl.Revision;
import org.tigris.subversion.javahl.Status;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.ISVNLogMessageChangePath;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNLogMessageChangePath;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNScheduleKind;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;
import org.tigris.subversion.svnclientadapter.javahl.JhlDirEntry;
import org.tigris.subversion.svnclientadapter.javahl.JhlLock;
import org.tigris.subversion.svnclientadapter.javahl.JhlLogMessage;
import org.tigris.subversion.svnclientadapter.javahl.JhlStatus;

public class JhlConverter {
    private static final Logger log = Logger.getLogger(JhlConverter.class.getName());

    private JhlConverter() {
    }

    public static Revision convert(SVNRevision sVNRevision) {
        switch (sVNRevision.getKind()) {
            case 5: {
                return Revision.BASE;
            }
            case 3: {
                return Revision.COMMITTED;
            }
            case 2: {
                return new Revision.DateSpec(((SVNRevision.DateSpec)sVNRevision).getDate());
            }
            case 7: {
                return Revision.HEAD;
            }
            case 1: {
                return new Revision.Number(((SVNRevision.Number)sVNRevision).getNumber());
            }
            case 4: {
                return Revision.PREVIOUS;
            }
            case 0: {
                return Revision.START;
            }
            case 6: {
                return Revision.WORKING;
            }
        }
        log.severe("unknown revision kind :" + sVNRevision.getKind());
        return Revision.START;
    }

    static SVNRevision convert(Revision revision) {
        switch (revision.getKind()) {
            case 5: {
                return SVNRevision.BASE;
            }
            case 3: {
                return SVNRevision.COMMITTED;
            }
            case 1: {
                Revision.Number number = (Revision.Number)revision;
                if (number.getNumber() == -1L) {
                    return null;
                }
                return new SVNRevision.Number(number.getNumber());
            }
            case 4: {
                return SVNRevision.PREVIOUS;
            }
            case 6: {
                return SVNRevision.WORKING;
            }
        }
        return SVNRevision.HEAD;
    }

    static SVNRevision.Number convertRevisionNumber(long l) {
        if (l == -1L) {
            return null;
        }
        return new SVNRevision.Number(l);
    }

    public static SVNNodeKind convertNodeKind(int n) {
        switch (n) {
            case 2: {
                return SVNNodeKind.DIR;
            }
            case 1: {
                return SVNNodeKind.FILE;
            }
            case 0: {
                return SVNNodeKind.NONE;
            }
            case 3: {
                return SVNNodeKind.UNKNOWN;
            }
        }
        log.severe("unknown node kind :" + n);
        return SVNNodeKind.UNKNOWN;
    }

    public static JhlStatus convert(Status status) {
        return new JhlStatus(status);
    }

    public static SVNStatusKind convertStatusKind(int n) {
        switch (n) {
            case 0: {
                return SVNStatusKind.NONE;
            }
            case 1: {
                return SVNStatusKind.NORMAL;
            }
            case 3: {
                return SVNStatusKind.ADDED;
            }
            case 6: {
                return SVNStatusKind.MISSING;
            }
            case 12: {
                return SVNStatusKind.INCOMPLETE;
            }
            case 4: {
                return SVNStatusKind.DELETED;
            }
            case 7: {
                return SVNStatusKind.REPLACED;
            }
            case 2: {
                return SVNStatusKind.MODIFIED;
            }
            case 8: {
                return SVNStatusKind.MERGED;
            }
            case 9: {
                return SVNStatusKind.CONFLICTED;
            }
            case 10: {
                return SVNStatusKind.OBSTRUCTED;
            }
            case 11: {
                return SVNStatusKind.IGNORED;
            }
            case 13: {
                return SVNStatusKind.EXTERNAL;
            }
            case 5: {
                return SVNStatusKind.UNVERSIONED;
            }
        }
        log.severe("unknown status kind :" + n);
        return SVNStatusKind.NONE;
    }

    static JhlDirEntry[] convert(DirEntry[] dirEntryArray) {
        JhlDirEntry[] jhlDirEntryArray = new JhlDirEntry[dirEntryArray.length];
        for (int i = 0; i < dirEntryArray.length; ++i) {
            jhlDirEntryArray[i] = new JhlDirEntry(dirEntryArray[i]);
        }
        return jhlDirEntryArray;
    }

    static JhlDirEntry convert(DirEntry dirEntry) {
        return new JhlDirEntry(dirEntry);
    }

    static ISVNLogMessage[] convert(LogMessage[] logMessageArray) {
        ISVNLogMessage[] iSVNLogMessageArray = new JhlLogMessage[logMessageArray.length];
        for (int i = 0; i < logMessageArray.length; ++i) {
            iSVNLogMessageArray[i] = new JhlLogMessage(logMessageArray[i]);
        }
        return iSVNLogMessageArray;
    }

    public static ISVNStatus[] convert(Status[] statusArray) {
        ISVNStatus[] iSVNStatusArray = new JhlStatus[statusArray.length];
        for (int i = 0; i < statusArray.length; ++i) {
            iSVNStatusArray[i] = new JhlStatus(statusArray[i]);
        }
        return iSVNStatusArray;
    }

    static ISVNLogMessageChangePath[] convert(ChangePath[] changePathArray) {
        if (changePathArray == null) {
            return new SVNLogMessageChangePath[0];
        }
        ISVNLogMessageChangePath[] iSVNLogMessageChangePathArray = new SVNLogMessageChangePath[changePathArray.length];
        for (int i = 0; i < changePathArray.length; ++i) {
            iSVNLogMessageChangePathArray[i] = new SVNLogMessageChangePath(changePathArray[i]);
        }
        return iSVNLogMessageChangePathArray;
    }

    public static SVNScheduleKind convertScheduleKind(int n) {
        switch (n) {
            case 0: {
                return SVNScheduleKind.NORMAL;
            }
            case 2: {
                return SVNScheduleKind.DELETE;
            }
            case 1: {
                return SVNScheduleKind.ADD;
            }
            case 3: {
                return SVNScheduleKind.REPLACE;
            }
        }
        log.severe("unknown schedule kind :" + n);
        return SVNScheduleKind.NORMAL;
    }

    public static JhlLock convertLock(Lock lock) {
        return new JhlLock(lock);
    }
}

