<?php $__env->startSection('content'); ?>
<div id="content-page" class="content-page">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="iq-card">
                    <div class="iq-card-header d-flex justify-content-between">
                        <div class="iq-header-title">
                            <h4 class="card-title"><?php echo e(isset($pageTitle) ? $pageTitle : trans('messages.list')); ?></h4>
                        </div>
                        <div class="iq-card-header-toolbar d-flex align-items-center">
                            <?php if($auth_user->can('permission add')): ?>
                                <a href="<?php echo e(route('permission.add',['type'=>'permission'])); ?>" class="float-right btn btn-sm btn-primary loadRemoteModel"><i class="fa fa-plus-circle"></i> <?php echo e(trans('messages.add_form_title',['form' => trans('messages.permission')  ])); ?></a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-12">
                <?php echo e(Form::open(['route' => 'permission.store','method' => 'post'])); ?>

                    <div class="accordion cursor" id="permissionList">
                        <?php $__currentLoopData = $permission; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $a = str_replace("_"," ",$key);
                                $k = ucwords($a);
                            ?>
                            <div class="iq-card mb-0">
                                <div class="iq-card-header d-flex justify-content-between collapsed btn" id="heading_<?php echo e($key); ?>" data-toggle="collapse" data-target="#pr_<?php echo e($key); ?>" aria-expanded="false" aria-controls="pr_<?php echo e($key); ?>">
                                    <div class="iq-header-title">
                                        <h5 class="mb-0"> <i class="fa fa-plus mr-10"></i><?php echo e($data->name); ?><span class="badge badge-secondary"></span></h4>
                                    </div>
                                </div>
                                <div id="pr_<?php echo e($key); ?>" class="collapse bg_light_gray" aria-labelledby="heading_<?php echo e($key); ?>" data-parent="#permissionList">
                                    <div class="iq-card-body table-responsive">
                                        <table class="table text-center table-bordered bg_white">
                                            <tr>
                                                <th><?php echo e(trans('messages.name')); ?></th>
                                                <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <th><b><?php echo e(ucwords(str_replace('_',' ',$role->name))); ?></b></th>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tr>
                                            <?php $__currentLoopData = $data->subpermission; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td><?php echo e($p->name); ?></td>
                                                    <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <td>
                                                            <input class="checkbox no-wh permission_check" id="permission-<?php echo e($role->id); ?>-<?php echo e($p->id); ?>" type="checkbox" name="permission[<?php echo e($p->name); ?>][]" value='<?php echo e($role->name); ?>' <?php echo e((checkRolePermission($role,$p->name)) ? 'checked' : ''); ?> <?php if($role->is_hidden): ?> disabled <?php endif; ?> >
                                                        </td>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </table>
                                        <input type="submit" name="Save" value="Save" class="btn btn-md btn-primary float-right mall-10">
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                <?php echo e(Form::close()); ?>

            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('body_bottom'); ?>
    <script>
        (function($) {
            "use strict";
            $(document).ready(function(){
                $(document).on('click','#permissionList .iq-card-header',function(){
                    if($(this).find('i').hasClass('fa-minus')){
                        $('#permissionList .iq-card-header i').removeClass('fa-plus').removeClass('fa-minus').addClass('fa-plus');
                        $(this).find('i').addClass('fa-plus').removeClass('fa-minus');
                    }else{
                        $('#permissionList .iq-card-header i').removeClass('fa-plus').removeClass('fa-minus').addClass('fa-plus');
                        $(this).find('i').removeClass('fa-plus').addClass('fa-minus');
                    }
                });
            });
        })(jQuery);
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/Dashboard/laravel-dashboard/resources/views/permission/index.blade.php ENDPATH**/ ?>