/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter;

import java.io.IOException;
import java.io.InputStream;
import org.tigris.subversion.svnclientadapter.ISVNAnnotations;

public class AnnotateInputStream
extends InputStream {
    private ISVNAnnotations annotations;
    private int currentLineNumber;
    private int currentPos;
    private String currentLine;
    private int available;

    public AnnotateInputStream(ISVNAnnotations iSVNAnnotations) {
        this.annotations = iSVNAnnotations;
        this.initialize();
    }

    private void initialize() {
        this.currentLine = this.annotations.getLine(0);
        this.currentLineNumber = 0;
        this.currentPos = 0;
        this.available = 0;
        int n = this.annotations.size();
        for (int i = 0; i < n; ++i) {
            this.available += this.annotations.getLine(i).length();
            if (i == n - 1) continue;
            ++this.available;
        }
    }

    public int read() throws IOException {
        if (this.currentLineNumber >= this.annotations.size()) {
            return -1;
        }
        if (this.currentPos > this.currentLine.length()) {
            this.getNextLine();
            if (this.currentLineNumber >= this.annotations.size()) {
                return -1;
            }
        }
        int n = this.currentPos == this.currentLine.length() ? 10 : (int)this.currentLine.charAt(this.currentPos);
        ++this.currentPos;
        --this.available;
        return n;
    }

    private void getNextLine() {
        ++this.currentLineNumber;
        this.currentPos = 0;
        this.currentLine = this.annotations.getLine(this.currentLineNumber);
    }

    public int available() throws IOException {
        return this.available;
    }

    public synchronized void reset() throws IOException {
        this.initialize();
    }
}

